#include <stdio.h>
#include <string.h>
#include <curl/curl.h>

#include "cli_websock_http.h"

// Estrutura para armazenar o corpo da resposta HTTP
struct MemoryStruct
{
    char *memory;
    size_t size;
};

// Estrutura para armazenar os dados do cabeçalho
struct HeaderData
{
    char *content_length;
};

char *pt_websocket_token;

// Função de callback para processar o corpo da resposta HTTP
size_t write_callback(void *contents, size_t size, size_t nmemb, void *userp)
{
    size_t real_size = size * nmemb;
    struct MemoryStruct *mem = (struct MemoryStruct *)userp;

    mem->memory = (char *)realloc(mem->memory, mem->size + real_size + 1);
    if (mem->memory == NULL)
    {
        fprintf(stderr, "Erro ao alocar memória para resposta HTTP\n");
        return 0;
    }

    memcpy(&(mem->memory[mem->size]), contents, real_size);
    mem->size += real_size;
    mem->memory[mem->size] = 0; // Null-terminate a string

    return real_size;
}

// Processa cabeçalho Set-Cookie
// Extrai token, ex.: Set-Cookie: token=E6JqSwLQ
void header_callback_extract_token(char *data)
{
    char *pt_aux;
    pt_aux = strdup(data); // Duplica string
    char *pt_aux2;
    pt_aux2 = strstr(pt_aux, "token=");
    pt_aux2+=6;
    pt_aux2 = strtok(pt_aux2, "\r\n");
    strcpy( pt_websocket_token, pt_aux2);
    free(pt_aux);   // Libera mem alloc
}

// Função de callback para processar os cabeçalhos HTTP
size_t header_callback(void *ptr, size_t size, size_t count, void *userdata)
{
    char *header_line = (char *)ptr;

    // printf("-------------------------------------------------------\n%.*s", (int)(size * count), header_line);

    // Verifique se o cabeçalho começa com "Set-Cookie"
    if (strstr(header_line, "Set-Cookie:") == header_line)
    {
        // Extrai o valor do cabeçalho "Set-Cookie"
        header_callback_extract_token(header_line);
    }

    return size * count;
}

// -----------------------------------------------------------
// Inicia autenticacao via HTTP e obtem token da sessao
// -----------------------------------------------------------
int cli_http_get_token( char *url, char *user, char *pass, char *token)
{
    CURL *curl;
    CURLcode res;
    int ret = 0;

    pt_websocket_token = token;

    curl = curl_easy_init();

    if (curl)
    {
        char auth_header[100];
        snprintf(auth_header, sizeof(auth_header), "%s:%s", user, pass);

        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_easy_setopt(curl, CURLOPT_USERPWD, auth_header);

        // Configurar a função de callback para processar o corpo da resposta
        struct MemoryStruct response_data;
        response_data.memory = NULL;
        response_data.size = 0;
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, (void *)&response_data);

        // Configurar a função de callback para os cabeçalhos
        curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, header_callback);

        res = curl_easy_perform(curl);

        if (res != CURLE_OK)
        {
            ret = -1;
            // printf("Erro na solicitação HTTP: %s\n", curl_easy_strerror(res));
        }
        else
        {
            ret = 0;
            // printf("Resposta HTTP recebida:\n%s\n", response_data.memory);
            // printf("Conexão HTTP OK\n");
        }

        // Libere a memória alocada para a resposta HTTP
        free(response_data.memory);
        curl_easy_cleanup(curl);
    }

    if ( strlen(token) == 0 )
    {
        // printf("websocket_token_str is NULL\n");
        ret = -1;
    }

    return ret;
}
