#include <libwebsockets.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>

#include "cli_websock_websock.h"

struct lws_context *context;
struct lws *wsi;
volatile int websock_connected = 0;
volatile int websock_force_exit = 0;
volatile int websock_writable = 0;

int cli_websock_callback(struct lws *wsi, enum lws_callback_reasons reason, void *user, void *in, size_t len)
{
    switch (reason)
    {
    case LWS_CALLBACK_CLIENT_ESTABLISHED:
        printf("Conexão WebSocket estabelecida\n");
        websock_connected = 1;
        // char *message = "Hello, WebSocket Server!";
        // lws_write(wsi, (unsigned char *)message, strlen(message), LWS_WRITE_TEXT);
        break;

    case LWS_CALLBACK_CLIENT_RECEIVE:
        printf("Recebido mensagem: %s\n", (char *)in);
        break;

    case LWS_CALLBACK_CLIENT_CONNECTION_ERROR:
        fprintf(stderr, "Erro na conexão\n");
        websock_force_exit = 1;
        break;

    case LWS_CALLBACK_CLOSED:
        printf("Conexão fechada\n");
        websock_force_exit = 1;
        break;

    case LWS_CALLBACK_SERVER_WRITEABLE:
        websock_writable = 1;
        printf("Websocket Writable\n");
        break;

    case LWS_CALLBACK_HTTP:
        printf("Websocket over http\n");
        break;

    case LWS_CALLBACK_CONNECTING:
        printf("Websocket is connecting\n");
        break;

    case LWS_CALLBACK_SERVER_NEW_CLIENT_INSTANTIATED:
        printf("Websocket new client instantiated\n");
        break;

    case LWS_CALLBACK_GET_THREAD_ID:
        printf("Websocket LWS_CALLBACK_GET_THREAD_ID\n");
        break;

    case LWS_CALLBACK_WSI_CREATE:
        printf("Websocket LWS_CALLBACK_WSI_CREATE\n");
        break;

    case LWS_CALLBACK_CLIENT_APPEND_HANDSHAKE_HEADER:
        printf("Websocket LWS_CALLBACK_CLIENT_APPEND_HANDSHAKE_HEADER\n");
        break;

    case LWS_CALLBACK_EVENT_WAIT_CANCELLED:
        printf("Websocket LWS_CALLBACK_EVENT_WAIT_CANCELLED\n");
        break;

    case LWS_CALLBACK_ESTABLISHED_CLIENT_HTTP:
        printf("Websocket LWS_CALLBACK_ESTABLISHED_CLIENT_HTTP\n");
        websock_writable = 1;
        break;

    case LWS_CALLBACK_CLIENT_WRITEABLE:
        printf("Websocket LWS_CALLBACK_CLIENT_WRITEABLE\n");
        break;

    case LWS_CALLBACK_CLIENT_RECEIVE_PONG:
        printf("Websocket LWS_CALLBACK_CLIENT_RECEIVE_PONG\n");
        break;

    case LWS_CALLBACK_CLIENT_FILTER_PRE_ESTABLISH:
        printf("Websocket LWS_CALLBACK_CLIENT_FILTER_PRE_ESTABLISH\n");
        break;

    case LWS_CALLBACK_PROTOCOL_INIT:
        printf("Websocket LWS_CALLBACK_PROTOCOL_INIT\n");
        break;

    case LWS_CALLBACK_CLIENT_HTTP_BIND_PROTOCOL:
        printf("Websocket LWS_CALLBACK_CLIENT_HTTP_BIND_PROTOCOL\n");
        break;

    default:
        fprintf(stderr, "callback reason: %d\n", reason);
        break;
    }

    return 0;
}

// Função para enviar uma mensagem para o servidor WebSocket
int cli_websock_send_message(const char *mensagem)
{
    if (wsi == NULL)
    {
        fprintf(stderr, "Erro: conexão WebSocket não está estabelecida\n");
        return -1;
    }

    // Defina o tipo de mensagem como texto (LWS_WRITE_TEXT)
    int tipoMensagem = LWS_WRITE_TEXT;

    // Calcule o tamanho da mensagem
    size_t tamanhoMensagem = strlen(mensagem);

    // Aloque um buffer para a mensagem
    unsigned char *buffer = (unsigned char *)malloc(LWS_PRE + tamanhoMensagem);

    if (buffer == NULL)
    {
        fprintf(stderr, "Erro ao alocar memória para a mensagem\n");
        return -1;
    }

    // Copie a mensagem para o buffer
    memcpy(buffer + LWS_PRE, mensagem, tamanhoMensagem);

    // Envie a mensagem para o servidor WebSocket
    int bytesEnviados = lws_write(wsi, buffer + LWS_PRE, tamanhoMensagem, tipoMensagem);

    if (bytesEnviados < 0)
    {
        fprintf(stderr, "Erro ao enviar mensagem para o servidor WebSocket\n");
        free(buffer);
        return -1;
    }

    printf("Mensagem enviada para o servidor: %s\n", mensagem);

    // Libere a memória do buffer
    free(buffer);

    return 0;
}

void *websock_task(void *arg)
{
    while (1)
    {
        // if (websock_connected)
        {
            cli_websock_lws_service();
            // Sleep(200);
            fprintf(stderr, "executou lws_service\n");
        }
    }
}

// -----------------------------------------------------------
// Inicia conexao informando token da sessao
// -----------------------------------------------------------
int cli_websock_start_connection(char *wsurl, int wsport, char *wspath, char *wstoken)
{
    pthread_t thread1;

    struct lws_context_creation_info info;
    memset(&info, 0, sizeof(info));

    struct lws_protocols protocols[] = {
        {"", cli_websock_callback, 0, MAX_MESSAGE_SIZE},
        {NULL, NULL, 0, 0},
    };

    info.port = CONTEXT_PORT_NO_LISTEN;
    info.protocols = protocols;
    info.gid = -1;
    info.uid = -1;

    context = lws_create_context(&info);

    if (context == NULL)
    {
        fprintf(stderr, "Erro ao criar o contexto WebSocket\n");
        return -1;
    }

    char wspathtoken[128];
    sprintf(wspathtoken, "%s/%s", wspath, wstoken);


    struct lws_client_connect_info ccinfo = {0};
    ccinfo.context = context;
    ccinfo.address = wsurl;
    ccinfo.port = wsport;
    ccinfo.path = wspathtoken;
    ccinfo.host = wsurl;
    ccinfo.origin = wsurl;
    ccinfo.protocol = "";
    ccinfo.pwsi = &wsi;


    if (lws_client_connect_via_info(&ccinfo) == NULL)
    {
        fprintf(stderr, "Erro ao criar a conexão WebSocket\n");
        lws_context_destroy(context);
        return -1;
    }

    // Envia a solicitação WebSocket personalizada como a primeira mensagem
    // lws_write(wsi, (unsigned char *)request, strlen(request), LWS_WRITE_HTTP);
    // Cria thread websock_task

    if (pthread_create(&thread1, NULL, websock_task, NULL) != 0)
        {
            fprintf(stderr, "Erro ao criar a websock_task\n");
            return 1;
        }

    return 0;
}


int cli_websock_lws_service()
{
    lws_service(context, 0);
}

int cli_websock_end()
{
    lws_context_destroy(context);
}
