#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <libwebsockets.h>
#include <cjson/cJSON.h>

#include "cli_websock_websock.h"
#include "cli_websock_http.h"

#define URL_WEBSOCKET_LOGIN     "http://192.168.17.52/ws_login"
#define WEBSOCKET_USER          "admin"
#define WEBSOCKET_PASS          "plugpwd"
#define WEBSOCKET_IP            "192.168.17.52"
#define WEBSOCKET_PORT          80
#define WEBSOCKET_PATH          "ws/"

extern void websocket_send_message_get_values();
extern void websocket_send_message_set_value(char *tag, char *value);

int main(void)
{
    int tecla;
    char websocket_token_str[WEBSOCK_TOKEN_MAX_LEN] = {0};
    char *pt_token = websocket_token_str;

    if (cli_http_get_token(URL_WEBSOCKET_LOGIN, WEBSOCKET_USER, WEBSOCKET_PASS, pt_token) != 0)
    {
        printf("Falha na autenticacao via HTTP - Fatal\n");
        return -1;
    }

    printf("Autenticacao via HTTP OK - get token: [%s]\n", websocket_token_str);

    cli_websock_start_connection(WEBSOCKET_IP, WEBSOCKET_PORT, WEBSOCKET_PATH, websocket_token_str);

    while (websock_force_exit == 0)
    {
        // Aguarda tecla com o comando...

        if (kbhit())
        {
            tecla = getch();

            if (tecla == 27)
            {
                break; // Tecla Esc para sair
            }

            if (tecla == 'g')
            {
                websocket_send_message_get_values();                // Le estado das tomadas
            }

            if (tecla == '0')
            {
                websocket_send_message_set_value("plug02", "0");    // Desliga tomada 2
            }

            if (tecla == '1')
            {
                websocket_send_message_set_value("plug02", "1");    // Liga tomada 2
            }

            printf("Tecla pressionada: %c\n", tecla);
        }
    }
    cli_websock_end();
    return 0;
}

void websocket_send_message_get_values()
{
    cJSON *root;

    root = cJSON_CreateObject();
    cJSON_AddStringToObject(root, "cmd", "get_value");
    cJSON_AddNumberToObject(root, "msgid", 12345);
    // Criar um novo array cJSON para representar o array de tags
    cJSON *tags_array = cJSON_CreateArray();
    // Adicionar elementos ao array de tags
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug01"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug02"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug03"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug04"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug05"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug06"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug07"));
    cJSON_AddItemToArray(tags_array, cJSON_CreateString("plug08"));
    // Adicionar o array de tags ao objeto principal
    cJSON_AddItemToObject(root, "tag", tags_array);

    char *my_json_string = cJSON_PrintUnformatted(root);
    if (my_json_string != NULL)
    {
        cli_websock_send_message(my_json_string);
        free(my_json_string);
    }
    cJSON_Delete(root);
}

void websocket_send_message_set_value(char *tag, char *value)
{
    cJSON *root;

    root = cJSON_CreateObject();
    cJSON_AddStringToObject(root, "cmd", "set_value");
    cJSON_AddNumberToObject(root, "msgid", 12345);
    cJSON_AddStringToObject(root, "tag", tag);
    cJSON_AddStringToObject(root, "value", value);

    char *my_json_string = cJSON_PrintUnformatted(root);
    if (my_json_string != NULL)
    {
        cli_websock_send_message(my_json_string);
        free(my_json_string);
    }
    cJSON_Delete(root);
}
